<?php

class Qb
{
	public static
		$config,
		$configDir;

	public static function init($cfg)
	{
		if (!file_exists($cfg))
			exit('Not configured. Run install.php first!');

		self::$config = include($cfg);
		self::$configDir = dirname($cfg).'/';
	}
}


class Router
{
	private static
		$_routes,
		$_items,
		$_vars;

	public static function request()
	{
		$tmp = parse_url(urldecode('http://'.$_SERVER['SERVER_NAME'].$_SERVER['REQUEST_URI']));
		$request = substr($tmp['path'], strlen(Qb::$config['prefix']));
		// Sort query parameters if any
		if (isset($tmp['query']))
		{
			$tmp = explode('&', $tmp['query']);
			sort($tmp);
			$request .= '?' . implode('&', $tmp);
		}
		return $request;
	}

	public static function route($request)
	{
		self::_prepare();

		self::$_vars = array();
		foreach (self::$_items as $item)
		{
			list($key, $quick, $pattern, $vars) = $item;
            $len = strlen($quick);

			if (substr($request, 0, $len) != $quick)
				continue;
			if (preg_match($pattern, $request, $matches))
			{
				for ($i = 1, $n = count($matches); $i < $n; ++$i)
					self::$_vars[$vars[$i-1]] = $matches[$i];
				return $key;
			}
		}

		return FALSE;
	}

	public static function getVars()
	{
		return self::$_vars;
	}

	public static function url($key, $vars = NULL)
	{
		self::_prepare();

		if (is_null($vars))
			return Qb::$config['baseUrl'].self::$_routes[$key];
		else
		{
			$url = self::$_routes[$key];
			foreach ($vars as $id => $value)
				$url = str_replace('{$'.$id.'}', $value, $url);
			return Qb::$config['baseUrl'].$url;
		}
	}

	private static function _prepare()
	{
		if (!is_null(self::$_routes))
			return;

		$raw = Qb::$configDir.'routes.php';
		$compiled = Qb::$config['cacheDir'].'routes.dat';

		if (file_exists($compiled) && filemtime($compiled) > filemtime($raw))
		{
			list(self::$_routes, self::$_items) = unserialize(file_get_contents($compiled));
			return;
		}

		self::$_routes = include($raw);
		self::$_items = array();
		foreach (self::$_routes as $key => &$route)
		{
			// Sort query parameters if any
			if (($p = strpos($route, '?')) !== FALSE)
			{
				$tmp = explode('&', substr($route, $p+1));
				sort($tmp);
				$route = substr($route, 0, $p+1) . implode('&', $tmp);
			}

			// Has the route string any parameter?
			if (($p = strpos($route, '{$')) === FALSE)
			{
				// No, it hasn't
				$quick = $route;
				$pattern = '|^'.preg_quote($route, '|').'$|';
				$vars = NULL;
			}
			else
			{
				// Yes, it has. Save heading substring
				$quick = substr($route, 0, $p);
				$pattern = '';
				$vars = array();
				// Process variable parts
				foreach (preg_split('|({\$.+})|U', $route, -1, PREG_SPLIT_DELIM_CAPTURE|PREG_SPLIT_NO_EMPTY) as $part)
				{
					if (substr($part, 0, 2) == '{$')
					{
						$vars[] = $var = substr($part, 2, -1);
						if ($var == 'page' || substr($var, -2) == 'id')
							$pattern .= '(\d+)';
						else
							$pattern .= '(.+)';
					}
					else
						$pattern .= preg_quote($part, '|');
				}
				$pattern = '|^'.$pattern.'$|';
			}
			self::$_items[] = array($key, $quick, $pattern, $vars);
		} // foreach routes

		file_put_contents($compiled, serialize(array(self::$_routes, self::$_items)));
	}

}


//
// Tests
//
Qb::init('./config/main.php');

header('Content-type: text/plain');

//echo 'url(topic.view.p) = '.Router::url('topic.view.p', array('tid'=>10, 'page'=>2))."\n\n";

$request = Router::request();
echo 'request = "'.$request."\"\n\n";

$route = Router::route($request);
echo 'route = '.$route."\n\n";
if ($route !== FALSE)
{
	echo "Variables:\n";
	print_r(Router::getVars());
}

