<?php
function myMemcache_error_handler($errno, $errmsg, $filename, $linenum, $vars)
{
	//if ($errno == E_NOTICE && strpos($errmsg, '(10060)') !== false)
	//{
		throw new Exception('Could not connect to Memcache server.');
	//}
}

if (!extension_loaded('memcache'))
{
	//error_log(':    "Memcache"');
	class Memcache
	{
		function get()			{return false;}
		function add()			{return false;}
		function set()			{return false;}
		function delete()		{return false;}
		function getStats()		{return array();}
		function getExtendedStats() {return array();}
		function getVersion()	{return 'Memcache not installed';}
		function Debug()		{}
		function flush()		{return false;}
	}
}

/**
 * myMemcache.
 *
 * @param array $servers	array(array('host'=>'xxxx'[, 'port'=>123, etc.]))
 * @param string $cache_data_path
 * @param int $file_save_probability
 */
class myMemcache
{
	const VERSION	= 'myMemcache 2.0';
	
	const MEMCACHE_HOST_DEFAULT	= 'localhost';
	const MEMCACHE_PORT_DEFAULT	= 11211;
	protected $serverpool		= array();
	protected $connected		= false;

	const CACHE_DATA_PATH_DEFAULT		= 'cache_data/';
	protected $cache_data_path			= '';
	protected $file_save_probability	= 1000;

	const CACHE_KEY_STATUS_MEMCACHE	= 1;
	const CACHE_KEY_STATUS_FILE		= 2;
	protected $last_key_status		= 0;

	const RESULT_STATUS_UNDEFINED	= 0;
	const RESULT_STATUS_HIT			= 1;
	const RESULT_STATUS_STORED		= 2;
	const RESULT_STATUS_FAILED		= -1;

	protected $debug		= false;
	const DEBUG_ECHO_KEYS	= 1;
	const DEBUG_SAVE_KEYS	= 2;
	protected $debug_level	= 0;


	function __construct($servers = array(), $cache_data_path = null, $file_save_probability = null)
	{
		if ($cache_data_path == null) $this->cache_data_path = self::CACHE_DATA_PATH_DEFAULT;
		else $this->cache_data_path = $cache_data_path;
		if ($file_save_probability != null && $file_save_probability > 0) $this->file_save_probability = $file_save_probability;
		if (sizeof($servers) == 0)
		{
			$servers[] = array('host' => self::MEMCACHE_HOST_DEFAULT, 'port' => self::MEMCACHE_PORT_DEFAULT);
		}
		foreach ($servers as $i => $s)
		{
			if ($s['host'] == null) $s['host'] = self::MEMCACHE_HOST_DEFAULT;
			if (empty($s['port'])) $s['port'] = self::MEMCACHE_PORT_DEFAULT;
			if (!isset($s['failure_callback'])) $s['failure_callback'] = null;
			if (!isset($s['status'])) $s['status'] = false;
			if (!isset($s['retry_interval'])) $s['retry_interval'] = -1;
			if (!isset($s['timeout'])) $s['timeout'] = 1;
			if (!isset($s['weight'])) $s['weight'] = 1;
			if (!isset($s['persistent'])) $s['persistent'] = false;
			$s['memcache'] = new Memcache();
			try
			{
				//set_error_handler("myMemcache_error_handler");
				$this->connected = $s['connected'] = $s['memcache']->connect($s['host'], $s['port'], $s['timeout']);
			} catch (Exception $e) {
				
			}
			//restore_error_handler();
			$this->serverpool[] = $s;
		}
	}
	
	public function Debug($debug_level = 0)
	{
		$this->debug = true;
		$this->debug_level = $debug_level;
	}

	public function lastKeyStatus()
	{
		return $this->last_key_status;
	}

	public function get($key, $serialize = false, $use_filecache = true)
	{
		try
		{
			//set_error_handler("myMemcache_error_handler");
			// TODO: cycle throw whole server pool
			$value = $this->serverpool[0]['memcache']->get($key);
			//restore_error_handler();

			if ($this->debug && $this->debug_level == self::DEBUG_ECHO_KEYS)
			{
				echo " [ ", ($value ? '+': '-'), "$key ] ";
				return false;
			}

			if (!$value)
			{
				throw new Exception('Data in memcache not found.');
			}
			else
			{
				$this->last_key_status = self::CACHE_KEY_STATUS_MEMCACHE;
				if ($this->debug && $this->debug_level == self::DEBUG_SAVE_KEYS
					|| $use_filecache && rand(1, $this->file_save_probability) == 1)
				{
					file_put_contents($this->cache_data_path.$key, ($serialize||!is_string($value)?serialize($value):$value));
				}
			}
		}
		catch (Exception $e)
		{
			//restore_error_handler();
			if ($use_filecache && file_exists($this->cache_data_path.$key))
			{
				$this->last_key_status = self::CACHE_KEY_STATUS_FILE;
				$value = file_get_contents($this->cache_data_path.$key);
				if ($serialize) $value = unserialize($value);
			}
			else
			{
				$this->last_key_status = 0;
				throw new Exception("Could not get cached data ($key).");
			}
		}
		return $value;
	}

	public function add($key, $var, $expire = 0, $compress = false)
	{
		if ($this->debug) return false;
		$return = true;
		foreach ($this->serverpool as $i => $s)
		{
			$return &= $this->serverpool[$i]['memcache']->add($key, $var, ($compress?MEMCACHE_COMPRESSED:false), $expire);
		}
		return $return;
	}

	public function set($key, $var, $expire = 0, $compress = false)
	{
		if ($this->debug) return false;
		if ($expire > time()) $expire = $expire-time();
		if ($expire > self::MEMCACHE_EXPIRE_MAX && $expire <= time()) $expire = 0;
		$return = true;
		foreach ($this->serverpool as $i => $s)
		{
			$return &= $this->serverpool[$i]['memcache']->set($key, $var, ($compress?MEMCACHE_COMPRESSED:false), $expire);
		}
		return $return;
	}
	
	public function delete($key)
	{
		if ($this->debug) return false;
		$return = true;
		foreach ($this->serverpool as $i => $s)
		{
			$return &= $this->serverpool[$i]['memcache']->delete($key);
		}
		return $return;
	}
	
	public function flush()
	{
		if ($this->debug) return false;
		$return = true;
		foreach ($this->serverpool as $i => $s)
		{
			$return &= $this->serverpool[$i]['memcache']->flush();
		}
		return $return;
	}
	
	public function getExtendedStats()
	{
		$return = array();
		foreach ($this->serverpool as $i => $s)
		{
			$return[$s['host'].':'.$s['port']] = $this->serverpool[$i]['memcache']->getStats();
		}
		return $return;
	}
	
	public function getStats()		{return $this->getExtendedStats();}
	
	public function getVersion()	{return 'myMemcache '.self::VERSION.'; Memcache '.$this->serverpool[0]['memcache']->getVersion();}
}
?>