<?php

define('SITE_ROOT', './');

class MyView
{
	public static function render($viewId, $viewData, $excludes = NULL)
	{
		extract($viewData, EXTR_REFS);
		if (is_null($excludes))
			array_walk_recursive($viewData, array('self', '_escapeAll'));
		else
			array_walk_recursive($viewData, array('self', '_escapeAllBut'), $excludes);
		require SITE_ROOT.'views/'.$viewId.'.php';
	}

	public static function fetch($viewId, $viewData, $excludes = NULL)
	{
		ob_start();
		self::render($viewId, $viewData, $excludes);
		return ob_get_clean();
	}

	private static function _escapeAllBut(&$item, $key, $excludes)
	{
		if (!in_array($key, $excludes))
			$item = htmlspecialchars($item);
	}

	private static function _escapeAll(&$item, $key)
	{
		$item = htmlspecialchars($item);
	}
}

$logs = unserialize(file_get_contents(SITE_ROOT.'private/logs.dat'));

$content = MyView::fetch('logs', array(
	'start' => 1252610188.9355,
	'logs' => $logs));
MyView::render('mainLayout', array(
	'page_title'=> 'Milestone I. test 2',
	'hypertext' => 'Some <b>tagged</b> text',
	'content' => $content),
	array('content')); // try to remove this array

?>