<?php

$arrByRef = array('alpha', '<b>b</b>eta', 'gamma');

$data = array(
	'title'		=> 'The Example page',
	'message'	=>	'Some text',
	'code'		=>	'The <b>bold</b> text',
	'xarr'		=>	array(
					'a' => 'AAA<u>UUU</u>BBB',
					'b' => array(
						'q' => 'B10',
						'r' => 'B11',
						12 => 'B12'),
					'd' => &$arrByRef)
);


function htmlescape($str)
{
	return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}


function parseTemplate(&$data, $file)
{
	// template is NOT php-script, read it as plain text
	$text = file_get_contents($file);
	// then if data provided, substitute placeholders
	if (!is_null($data) && count($data))
	{
		// split to parts divided by "<!-- key -->"
		$arr = preg_split('/(<!--.*-->)/', $text, -1, PREG_SPLIT_DELIM_CAPTURE);
		// ... if any, process substitutions
		if (count($arr) > 1)
		{
			$text = '';
			foreach ($arr as $clause)
			{
				if (substr($clause, 0, 4) == '<!--')
				{
					// strip "<!--" and "-->"
					$key = trim(substr($clause, 4, -3));
					$escape = FALSE;
					$success = TRUE;

					if ($key{0} == '@')
					{
						$key = substr($key, 1);
						$escape = TRUE;
					}

					if (strpos($key, ':') !== FALSE)
					{
						$keys = explode(':', $key);
						$d =& $data;
						foreach ($keys as $key)
						{
							if (isset($d[$key]))
								$d = &$d[$key];	// iterate like chained list
							else
							{
								$success = FALSE;
								break;
							}
						}
						if ($success)
							$clause = $d;
					}
					else
					{
						if (isset($data[$key]))
							$clause = $data[$key];
					}

					if ($success && $escape)
						$clause = htmlescape($clause);

				}

				$text .= $clause;
			}
		}
	}

	echo $text;
}

parseTemplate($data, './example.tpl');
