<?php
if (!defined("__STORAGE__"))
{
	define("__STORAGE__", true);

	// constants to store uploaded files on disk
	define("FILE_UPLOAD_DIR", "../../files/ie/");
	define("FILE_UPLOAD_DIR_FRONT", "files/ie/");
	define("FILE_UPLOAD_SCRIPT_FRONT", "user/ffdb.php?f=");
	define("FILE_UPLOAD_TMP_PREFIX", "tmp");
	define("FILE_UPLOAD_MAX_SIZE", "16777215"); // 16 Mb in bytes

	class Storage
	{
		var $id = null;
		var $table = null;
		var $index = null;
		var $connection = null;
		var $debug = false;

		function Storage(&$connection, $table = null, $index = null)
		{
			if (!class_exists("DB")) echo "<br /><b>Warning!</b> Class <i><b>DB</b></i> must be defined before class <i><b>Storage</b></i>.";
			$this->id = null;
			$this->connection = $connection;
			$this->table = $table;
			$this->index = $index;
			$this->aplite_file_store_db = (!isset($GLOBALS["aplite_file_store_db"])) ? FALSE : (bool)$GLOBALS["aplite_file_store_db"];
			$this->aplite_file_db_search = $this->connection->blob_search_enable & $this->aplite_file_store_db;
			$this->SetDebug(false);
		}

		function SetId($id)
		{
			if ($id != null)
				if ($this->CountRecs($this->table, $this->index."=".(int)$id) > 0)
					$this->id = (int)$id;
		}

		function GetId()
		{
			return $this->id;
		}

		function GetConnection()
		{
			return $this->connection;
		}

		function RestoreConnection(&$connection)
		{
			$this->connection = $connection;
		}

		function SetDebug($s = "")
		{
			if ($s === "")	$this->debug = !$this->debug;
			else			$this->debug = (bool)$s;
		}

		function GetTitle()
		{
			if ($this->id == null)	return false;
			return $this->GetRec($this->table, "Title", $this->index."=".$this->id);
		}

		function _GetEntityProperties($table, $property = PROPERTY_AUTO_INCREMENT)
		{
			return $this->connection->getTableProperties($table, $property);
		}

		function GetParam($param)
		{
			if (!isset($this->$param))	return false;
			else						return $this->$param;
		}

		function CountRecs($table, $cond = "")
		{
			if ($table === null)	$table = $this->table;
			return $this->connection->countTableRecs($table, $cond);
		}

		/**
		 * Storage::StoreFile()
		 *        ,    .
		 * 
		 * @param	$f_data			array	data from $_FILES[uploaded file]
		 * @param	$f_name			mixed	local filename (NULL or anything for db, string for disk)
		 * @param	$table			string	tablename to register/store the file
		 * @param	$col			string	columnname
		 * @param	$where			string	ID of the row
		 * @param	$db				boolean override global setting 'aplite_file_store_db'
		 * @param	$allowed_types	array	supported file types for uploading. if set all other types should be rejected (yet to be implemented)
		 * @return	boolean	TRUE on success, otherwise FALSE
		 */
		function StoreFile(&$f_data, $f_name, $table, $col, $where, $db = true, $allowed_types = array())
		{
			if (!is_uploaded_file($f_data['tmp_name']) || filesize($f_data['tmp_name'])>FILE_UPLOAD_MAX_SIZE) return false;
			if ($this->aplite_file_store_db && $db) // store in DB
			{
				$this->connection->LoadFile($f_data, $table, $col, $where);
			}
			else // store on disk
			{
				 if (move_uploaded_file($f_data['tmp_name'], $f_name))
				 {
				 	$this->connection->LoadFile($f_data, $table, $col, $where, false);
				 }
			}
			return true;
		}
		/**
		 * Storage::DeleteFile()
		 *      -     ,    .
		 * 
		 * @param	$f_name		mixed	local filename (NULL or anything for db, string for disk)
		 * @param	$table		string	tablename where the file was registered/stored
		 * @param	$col		string	columnname
		 * @param	$where		string	ID of the row
		 * @param	$db			boolean override global setting 'aplite_file_store_db'
		 * @return	boolean	TRUE on success, otherwise FALSE
		 */
		function DeleteFile($f_name, $table, $col, $where, $db = true)
		{
			if ($this->aplite_file_store_db && $db) // stored in DB
			{
				$this->connection->DeleteFile($table, $col, $where);
			}
			else // store on disk
			{
				if (file_exists($f_name))
				{
					unlink($f_name);
				}
				$this->connection->DeleteFile($table, $col, $where, false);
			}
			return true;
		}

		/**
		 * Storage::GetRec()
		 *
		 * @param $table	string tablename
		 * @param $fields	string commaseparatedlist
		 * @param $cond		string sqlcondition
		 * @return	string fieldvalue	if there's only 1 field
		 * 			array tablerow(fieldname1=>fieldvalue1,fieldname2=>fieldvalue2[,...])
		 */
		function GetRec($table, $fields, $cond)
		{
			$sql = "SELECT ".$fields." FROM ".$table." WHERE ".$cond;
			if ($this->debug) echo "[",$sql,"]";
			$res = $this->connection->exec($sql);
			$ret = false;
            if ($this->connection->getRowCount($res) == 0) return $ret;
			$fc = $this->connection->getFieldCount($res);
			if ($fc == 1)
				$ret = $this->connection->getField($res);
			else
				for($i = 0; $i < $fc; $i++)
					$ret[$this->connection->getFieldName($res, $i)] = $this->connection->getField($res, 0, $i);
            return $ret;
		}

		/**
		 * Storage::GetPairs()
		 *
		 * @param $table	string tablename
		 * @param $key		NULL
		 * 					string
		 * @param $value	string
		 * @param $order	string sqlorder
		 * @param $cond		string sqlcondition
		 * @return 	array rows(value1[,...])	if $key===NULL
		 * 			array rows(key1=>value1[,...])
		 */
		function GetPairs($table, $key, $value, $order = "1", $cond = SQL_WHERE_CLAUSE_NEUTRAL)
		{
			$sql = "SELECT ".(($key!==null)?$key.",":"")."$value FROM $table WHERE $cond ORDER BY $order";
			$ret = array();
			if ($this->debug) echo "[",$sql,"]";
			if ($res = $this->connection->exec($sql))
			{
				$rc = $this->connection->getRowCount($res);
				if ($key===null)
					for($j = 0; $j < $rc; $j++)
						$ret[] = $this->connection->getField($res, $j, 0);
				else
					for($j = 0; $j < $rc; $j++)
						$ret[$this->connection->getField($res, $j, 0)] = $this->connection->getField($res, $j, 1);
			}
			return $ret;
		}

		/**
		 * Storage::GetAllRecs()
		 *
		 * @param $table	string tablename
		 * @param $fields	string commaseparatedlist
		 * @param $key		NULL
		 * 					string keyfieldname
		 * @param $order	string sqlorder
		 * @param $cond		string sqlcondition
		 * @param $limit	string
		 * @return	array rows(array row0(fieldname1=>fieldvalue1[,...])[,...])		if $key===NULL
		 * 			array rows(row0fieldvalue1=>array row(row0fieldname2=>row0fieldvalue2[,...])[,...])
		 */
		function GetAllRecs($table, $fields, $key = null, $order = "1", $cond = SQL_WHERE_CLAUSE_NEUTRAL, $limit = "")
		{
			if ($fields!="*")
				$fields = (($key!==null)?$key.",":"").$fields;
			$sql = $this->connection->PrepareQuery($table, $fields, $cond, $order, $limit);
			$ret = array();
			if ($this->debug) echo "[",$sql,"]";
			if ($res = $this->connection->exec($sql))
			{
				$fc = $this->connection->getFieldCount($res);
				$rc = $this->connection->getRowCount($res);
				for($i = 0; $i < $fc; $i++)
					$filedNames[] = $this->connection->getFieldName($res, $i);
				if ($key===null)
					for($j = 0; $j < $rc; $j++)
						for($i = 0; $i < $fc; $i++)
							$ret[$j][$filedNames[$i]] = $this->connection->getField($res, $j, $i);
				else
					for($j = 0; $j < $rc; $j++)
						for($i = 1; $i < $fc; $i++)
							$ret[$this->connection->getField($res, $j, 0)][$filedNames[$i]] = $this->connection->getField($res, $j, $i);
			}
			return $ret;
		}
	}
}
?>