<?php
if(!defined("__DB__")) {

	define("__DB__", true);
	define("PROPERTY_AUTO_INCREMENT", "IDENT_CURRENT");
	define("SQL_WHERE_CLAUSE_NEUTRAL", "(1=1)");
	define("SQL_FUNCTION_CURRENTDATE", "GETDATE()");

	define("SQL_DATATYPE_DEFAULT", "VARCHAR(255)");
	define("SQL_DATATYPE_DATE", "SMALLDATETIME");
	define("SQL_DATATYPE_LIST", "VARCHAR(8000)");
	define("SQL_DATATYPE_BLOB", "IMAGE");
	define("SQL_DATATYPE_TEXT", "TEXT");
	
	define("SQL_DATATYPE_TYPECOLUMN", "CHAR(3)");
	define("SQL_FULLTEXT_CATALOG_DEFAULT", "aplite");

	class DBMSSQL {
		var $connectionId = false;
		var $server = false;
		var $database = false;
		var $odbc = false;
		var $user = false;
		var $password = false;
		
		var $debug = false;
		
		function DBMSSQL($datasource, $database, $user, $password, $persistent = false) {
			$this->server = $datasource;
			$this->database = $database;
			$this->user = $user;
			$this->password = $password;
			$this->connect($persistent);
			/* definitions for table creation */
			$this->field_types = array(
				"identity" => "numeric(18, 0) IDENTITY NOT NULL",
				"timestamp" => "datetime not null default ".SQL_FUNCTION_CURRENTDATE,
				"counter" => "int NOT NULL DEFAULT 0"
			);
			$this->key_types = array(
				"primary" => "constraint PK_%tablename% primary key"
			);
			$this->blob_search_enable = true;
			$this->debug = false;
		}

		function SetDebug($s = "")
		{
			if ($s === "")	$this->debug = !$this->debug;
			else			$this->debug = (bool)$s;
		}

		function EscapeString($s)
		{
			return (ini_get("magic_quotes_sybase")=="1" ? $s : str_replace("'", "''", $s));
		}
		function EscapeName($s)
		{
			if (is_array($s)) return "[".implode('],[',$s)."]";
			else return "[".$s."]";
		}

		function RLIKE($s)
		{
			return "LIKE '%".$s."%'";
		}
		function CastDate($s)
		{
			return "cast(".$s." as datetime)";
		}
		/*
		 * DBMSSQL::FormatDate()
		 *   MS SQL Server'     ,     .
		 * 
		 * @param	$s		string	field name (!       !)
		 * @return	string	  ,     yyyy-mm-dd hh:mi:ss(24h)
		 */
		function FormatDate($s)
		{
			return "convert(varchar, $s, 120)";
		}
		function DataLen($tbl, $col, $cond)
		{
			if($this->isConnected()) {
				$sql = "SELECT DATALENGTH(".$this->EscapeName($col."_DATA").") FROM ".$tbl." WHERE ".$cond;
				return $this->getField($this->exec($sql));
			}
			else return false;
		}

		function connect($persistent = false) {
			if($persistent) {
				$this->connectionId = mssql_pconnect($this->server, $this->user, $this->password);
			} else {
				$this->connectionId = mssql_connect($this->server, $this->user, $this->password);
			}
			if($this->isConnected()) {
				$result = mssql_select_db($this->database, $this->connectionId);
				if(!$result) {
					$this->disconnect();
				}
			} else {
				$result = false;
			}
			return $result;
		}

		function disconnect() {
			if($this->isConnected()) {
				mssql_close($this->connectionId);
			}
			$this->connectionId = false;
			return $this->isConnected();
		}

		function isConnected() {
			return ($this->connectionId != false);
		}

		function PrepareQuery($table, $fields, $cond, $order, $limit)
		{
			$limit = explode(",", $limit);
			if (!isset($limit[1]) || $limit[1]=="-1" || $limit[0]=="")
				$return = "SELECT " . $fields . " FROM " . $table . " WHERE " . $cond . " ORDER BY " . $order;
			else
			{
				$order_alt = " DESC";
				if (preg_match("/^(.+)DESC$/i", $order, $match)==0)
					if (preg_match("/^(.+)ASC$/i", $order, $match)==0) $order_column = $order;
					else
						$order_column = $match[1];
				else
				{
					$order_alt = " ASC";
					$order_column = $match[1];
				}
				echo strrpos("ASC", strtoupper($order));
				$s1 = "SELECT TOP ".($limit[0]+$limit[1])." ".$fields." FROM ".$table." WHERE ".$cond." ORDER BY ".$order;
				$s2 = "SELECT TOP ".$limit[1]." ".$fields." FROM (".$s1.") AS t1 ORDER BY ".$order_column.$order_alt;
				$return = "SELECT ".$fields." FROM (".$s2.") AS t2 ORDER BY ".$order;
			}
			return $return;
		}

		function PrepareColumn($kind, $field, $value)
		{
			switch($kind)
			{
				case "date":
					$field = $field."_DATE";
					break;
				default:
					break;
			}
			return " ".$this->EscapeName($field)."='$value' ";
		}

		function exec($query) { 
			if($this->isConnected()) {
				$result = mssql_query($query, $this->connectionId);
				if ($this->debug) echo "[DBMSSQL][$query]\n";
			} else {
				$result = false;
			}
			if (!$result) echo "DB Error: [DBMSSQL][",$query,"]";
			return $result;
		}

		function getAffected($query='') {
			if ($this->isConnected()) {
				if ($query!='')	{
					if (!$this->exec($query)) return false;
				}
				$result = $this->getField($this->exec('SELECT @@ROWCOUNT'));
			} else {
				$result = false;
			}
			return $result;
		}

		function getFieldCount($resultsetId) {
			if($this->isConnected()) {
				$result = mssql_num_fields($resultsetId);
			} else {
				$result = false;
			}
			return $result;
		}

		function getRowCount($resultsetId) {
			if($this->isConnected()) {
				$result = mssql_num_rows($resultsetId);
			} else {
				$result = false;
			}
			return $result;
		}

		function getField($resultsetId, $rowId = 0, $fieldId = 0) {
			if($this->isConnected()) {
				$result = mssql_result($resultsetId, $rowId, $fieldId);
			} else {
				$result = false;
			}
			return $result;
		}

		function getFieldName($resultsetId, $field) {
			if($this->isConnected()) {
				$field_info = mssql_fetch_field($resultsetId, $field);
				$result = $field_info->name;
			} else {
				$result = false;
			}
			return $result;	
		}

		function fetch($resultsetId) {
			if($this->isConnected()) {
				$result = mssql_fetch_array($resultsetId);
			} else {
				$result = false;
			}
			return $result;
		}

		function getInsertedId() {
			if($this->isConnected()) {
				$result = $this->getField($this->exec("SELECT @@IDENTITY"));
			} else {
				$result = false;
			}
			return $result;
		}

		function free($resultsetId) {
			if($this->isConnected()) {
				$result = mssql_free_result($resultsetId);
			} else {
				$result = false;
			}
			return $result;
		}

		function createTable($tablename, $fields, $keys, $extra=array())
		{
			if (count($fields)==0) return false;
//			$sql = "if exists (select 1 from  sysobjects where  id = object_id('ie".$this->id."') and type = 'U') drop table ie".$this->id;
//			if ($this->connection->exec($sql))
			if (1)
			{
				$sql = "CREATE TABLE ".$tablename." (";
				$sep = "";
				foreach ($fields as $f => $d)
				{
					$sql .= $sep . $f . " " . $this->field_types[$d];
					$sep = ",";
				}
				foreach ($keys as $k => $v)
				{
					$sql .= ",". str_replace("%tablename%", strtoupper($tablename), $this->key_types[$v]) ."(".$k.")";
				}
				$sql .= ")";
				if($this->exec($sql))	foreach ($extra as $e)
					{
						switch ($e)
						{
							case "fulltext":
							$this->exec("sp_fulltext_table '".$tablename."', 'Create', '".SQL_FULLTEXT_CATALOG_DEFAULT."', PK_".$tablename);
							break;
						}
					}
				return true;
			}
			else return false;
		}

		function createColumn($kind, $table, $identifier, $type)
		{
			$identifier = $this->EscapeString($identifier);
			switch ($kind)
			{
				case "date":
					$this->exec("ALTER TABLE ".$table." ADD ".$this->EscapeName($identifier."_DATE")." ".$type);
					$type = "AS (CONVERT(CHAR(4),YEAR(".$this->EscapeName($identifier."_DATE").")) + '-' + CONVERT(CHAR(2),MONTH(".$this->EscapeName($identifier."_DATE").")) + '-' + CONVERT(CHAR(2),DAY(".$this->EscapeName($identifier."_DATE").")))";
				default:
					break;
			}
			$sql = "ALTER TABLE ".$table." ADD ".$this->EscapeName($identifier)." ".$type;
			$this->exec($sql);
		}

		function dropColumn($kind, $table, $identifier)
		{
			$identifier = $this->EscapeString($identifier);
			$sql = "ALTER TABLE ".$table." DROP COLUMN ".$this->EscapeName($identifier);
			$this->exec($sql);
			switch ($kind)
			{
				case "date":
					$this->exec("ALTER TABLE ".$table." DROP COLUMN ".$this->EscapeName($identifier."_DATE"));
				default:
					break;
			}
		}

		function dropTable($tablename, $extra=array())
		{
			foreach ($extra as $e)
			{
				switch ($e)
				{
					case "fulltext":
					$this->exec("sp_fulltext_table '".$tablename."', 'Drop'");
					break;
				}
			}
			$sql = "DROP TABLE ".$tablename;
			$this->exec($sql);
		}

		function getTableProperties($table, $property = "")
		{
			return $this->getField($this->exec("SELECT IDENT_CURRENT('".$table."')+1"));
		}

		function countTableRecs($table, $cond = "")
		{
			if(!$this->isConnected())	return false;
			$sql = "SELECT COUNT(*) FROM $table";
			if ($cond != "")	$sql .= " WHERE ".$cond;
			return $this->getField($this->exec($sql));
		}

		function AddRowDefault($table)
		{
			return "INSERT INTO ".$table." DEFAULT VALUES";
		}

		function LoadFile(&$f_name, $table, $col, $where, $db=true)
		{
			$pi = pathinfo($f_name['name']);
//			$datastring = file_get_contents($f_name['tmp_name']);
//			$data = unpack("H*hex", $datastring);
//			if ($this->exec("UPDATE ".$table." SET ".$col."_DATA = 0x".$data['hex']." WHERE ".$where))
			if ($db)
			{
				if ($this->exec("EXEC readImageFromfile '".$f_name['tmp_name']."', ".$table.", ".$col."_DATA, 'WHERE ".$where."'"))
				{
					$this->exec("UPDATE ".$table." SET [".$col."] = '".$pi["basename"]."' WHERE ".$where);
					$this->exec("UPDATE ".$table." SET ".$col."_DATA_TYPE = '".$pi["extension"]."' WHERE ".$where);
					return true;
				}
				else return false;
			}
			else
			{
				return $this->exec("UPDATE ".$table." SET [".$col."] = '".$pi["basename"]."' WHERE ".$where);
			}
		}

		function DeleteFile($table, $col, $where, $db=true)
		{
			if ($db)
			{
				if ($this->exec("UPDATE ".$table." SET ".$col."_DATA = '' WHERE ".$where))
				{
					$this->exec("UPDATE ".$table." SET [".$col."] = '' WHERE ".$where);
					$this->exec("UPDATE ".$table." SET ".$col."_DATA_TYPE = '' WHERE ".$where);
					return true;
				}
				else return false;
			}
			else
			{
				return $this->exec("UPDATE ".$table." SET [".$col."] = NULL WHERE ".$where);
			}
		}

		/**
		 * DBMSSQL::AddFulltext()
		 * Comment: some values of $kind require extra actions (e.g. 'file')
		 */
		function AddFulltext($tablename, $column, $kind="")
		{
			$type_column = ""; // for 'image' data type
			switch($kind)
			{
				case "file":
					$column = $column."_DATA";
					$type_column = $column."_TYPE";
					$sql = "ALTER TABLE ".$tablename." ADD ".$type_column." ".SQL_DATATYPE_TYPECOLUMN;
					$this->exec($sql);
				break;
			}
			$this->exec("EXEC sp_fulltext_column '$tablename', '".$column."', 'add', 0".($type_column!=""?", $type_column":""));
			$this->ActivateFullText($tablename);
			return true;
		}

		function ActivateFullText($tablename)
		{
			$res = $this->exec("sp_help_fulltext_tables '".SQL_FULLTEXT_CATALOG_DEFAULT."', '".$tablename."'");
			$row = $this->fetch($res);
			if ($row["FULLTEXT_INDEX_ACTIVE"]=="0")
			{
				$this->exec("sp_fulltext_table '".$tablename."', 'Activate'");
			}
			if ($this->getField($this->exec("select OBJECTPROPERTY ( OBJECT_ID('".$tablename."'), 'TableFullTextChangeTrackingOn')")) == "0")
				$this->exec("sp_fulltext_table '".$tablename."', 'start_change_tracking'");
			if ($this->getField($this->exec("select OBJECTPROPERTY ( OBJECT_ID('".$tablename."'), 'TableFullTextBackgroundUpdateIndexOn')")) == "0")
				$this->exec("sp_fulltext_table '".$tablename."', 'start_background_updateindex'");
			return true;
		}

		/**
		 *
		 */
		function DropFulltext($tablename, $column, $kind="")
		{
			$type_column = ""; // for 'image' data type
			$extra_sql = array();
			switch($kind)
			{
				case "file":
					$column = $column."_DATA";
					$type_column = $column."_TYPE";
					$extra_sql[] = "ALTER TABLE ".$tablename." DROP COLUMN ".$type_column;
				break;
			}
			$this->exec("EXEC sp_fulltext_column '$tablename', '".$column."', 'drop'");
			foreach ($extra_sql as $sql)
				$this->exec($sql);
			return true;
		}
	} // end of class DBMSSQL definition

	class DB extends DBMSSQL {
		function DB($dbServer = "127.0.0.1", $dbDatabase="aplite", $dbUser="root", $dbPassword="", $dbPersistent=false)
		{
			$this->DBMSSQL($dbServer, $dbDatabase, $dbUser, $dbPassword, $dbPersistent);
		}
	}
}
?>